# 修改视图

针对用户表和员工表：

```mysql
create table employee(
    id int primary key auto_increment,
    name varchar(256),
    address varchar(1024),
    dept varchar(64)
    -- ignore more
);

create table customer(
                         id int primary key auto_increment,
                         name varchar(256),
                         address varchar(1024),
                         level int
    -- ignore more
)
```

Joe 建立了联系人视图：

```mysql
create view v_contacts as
    select name, address from employee
    union
    select name, address from customer;
```

现在，他想要加入一列 catalog ，区分员工和顾客，下面哪一个做法是错的？


## 答案

```mysql
create if not exists view v_contacts as
    select name, address, 'employee' as catalog from employee
    union
    select name, address, 'customer' as catalog from customer;
```

## 选项

## A

```mysql
alter view v_contacts as
    select name, address, 'employee' as catalog from employee
    union
    select name, address, 'customer' as catalog from customer;
    
```


### B

```mysql
create or replace view v_contacts as
    select name, address, 'employee' as catalog from employee
    union
    select name, address, 'customer' as catalog from customer;
    
```

### C

```mysql
drop view v_contacts;
create view v_contacts as
    select name, address, 'employee' as catalog from employee
    union
    select name, address, 'customer' as catalog from customer;
    
```